open Array;;

exception Erreur;;


(***** L'algorithme d'approximation glouton *****)

let get_nearest_neighbour m l = let mini = ref 1000000. and indice =ref 0
						    and bidon = ref 0
						    in
for i = 0 to (Array.length l) -1 do
  if l.(i)=0 &&  m.(i) < !mini then begin
    bidon := 1;
    indice := i;
    mini := m.(i);
  end;
done;
if !bidon = 0 then raise Erreur else !indice;;


(***** La creation du graphe glouton *****)

let rec greedy_approx1 g depart actuel deja_vu =
  deja_vu.(actuel) <- 1;
  try
    let k = get_nearest_neighbour g.(actuel) deja_vu in
    let tmp = greedy_approx1 g depart k deja_vu in
    (fst tmp +. g.(actuel).(k) , k::(snd tmp))
  with
      Erreur -> g.(actuel).(depart),[depart];;

let greedy_approx g =
  let tmp = greedy_approx1 g 0 0 (Array.make (Array.length g) 0) in
  (fst tmp, 0::(snd tmp));;

(* Creation d'un type evitant des erreurs de typages pour le cas ou le
   glouton est meilleur a un point donne de l'arbre *)

type resultat = Cut | Chemin of float * int list;;


(***** L'algorithme de recherche pour le tsp *****)

let rec coupure_search g depart actuel deja_vu borne =
  let cout_min =  ref borne and parcours_min = ref [] and trouve = ref
    false and  teste = ref false in
  deja_vu.(actuel) <- 1;

  for i = 0 to (Array.length g) -1 do
    if deja_vu.(i) = 0 then
      begin
	teste := true;
	if !cout_min >= g.(actuel).(i) then
	  let res = coupure_search g depart i deja_vu (!cout_min -. g.(actuel).(i)) in
	  match res with
	      Chemin (cout,parcours) when cout +. g.(actuel).(i) <=
		!cout_min -> cout_min := g.(actuel).(i) +. cout;
		  parcours_min := i::parcours;
		  trouve := true;
	    |_ -> ()
      end;
  done;
  deja_vu.(actuel) <- 0;
  match (!trouve, !teste) with
      true, _ -> (Chemin (!cout_min,!parcours_min))
    |false, true -> Cut
    |false, false -> Chemin (g.(actuel).(depart), [depart]);;



(********** Le voyageur proprement dit avec coupure **********)

let tsp_coupure g =
  let a= make (Array.length g) 0 in
  let glouton = greedy_approx g in
  let tmp = coupure_search g 0 0 a (fst glouton) in
  match tmp with
      Cut -> glouton
    |Chemin (cout,parcours) -> cout, 0::parcours;;


(***** Creation des graphes de tests pour le voyageur de commerce *****)

let create_graph n = make_matrix n n 0.0;;


(* Les matrices symbolisent le graphe : a chaque point m_(i,j) de la matrice
   est associe la distance euclidienne entre le sommet S_i et le
   sommet S_j ; etablit les arretes S de telle
   sorte que (S,A) soit complet en utilisant "norme" pour ponderer *)

let dist_eucl a b = sqrt ((fst a -. fst b)**2.0 +. (snd a -. snd
  b)**2.0);;

let complete_graph arretes =
  let tab = create_graph (Array.length arretes) in
  for i = 0 to (Array.length arretes)-1 do
    for j=0 to (Array.length arretes)-1 do
      tab.(i).(j) <- dist_eucl arretes.(i) arretes.(j);
    done;
  done;
  tab;;

let random_graph n x_lim y_lim=
  let arretes= make n (0.0,0.0) in
  Random.self_init ();
  for i=0 to n-1 do
    arretes.(i) <- (Random.float x_lim,Random.float y_lim);
  done;
  arretes, complete_graph arretes;;


(********** Rendu graphique des graphes de test **********)

let print_graph s=
  let n = Array.length s in
  Graphics.clear_graph ();
  Graphics.set_text_size 15;
  Graphics.set_window_title "TIPE 2003 J.B. et C.B. - Problme du voyageur de commerce";
  Graphics.draw_segments [|(10,0,10,Graphics.size_y ());(0,12,Graphics.size_x (),12)|];

  for i = 0 to n-1 do
    let x= int_of_float (float_of_int (Graphics.size_x () -20) *. (fst s.(i)) ) +10
    and y=int_of_float (float_of_int (Graphics.size_y () -20) *. (snd s.(i))) +10 in

    Graphics.draw_circle x y 5;
    Graphics.moveto (x+4) (y+3);
    Graphics.draw_string (string_of_int i);

  done;;


let print_res r s offset =
  let l = Array.of_list (snd r) in
  
  print_float (fst r);
  print_string " : [";
  
  for i = 0 to (Array.length s) -1 do
    print_int l.(i);
    print_string ";";
    let x1 = int_of_float ( float_of_int ( Graphics.size_x () - 20) *. (fst s.(l.(i))) ) + 10 + offset
    and y1 = int_of_float ( float_of_int ( Graphics.size_y () - 20) *. (snd s.(l.(i))) ) + 10 + offset
    and x2 = int_of_float ( float_of_int ( Graphics.size_x () - 20) *. (fst s.(l.(i+1))) ) + 10 + offset
    and y2 = int_of_float ( float_of_int ( Graphics.size_y () - 20) *. (snd s.(l.(i+1))) ) + 10 + offset in
    Graphics.draw_segments [|(x1,y1,x2,y2)|];
    
  done;
  
  print_string "]";
  print_newline ();;


let main () =
  Graphics.open_graph "";
  let z=int_of_string Sys.argv.(1) in
  let tmp = random_graph z 1.0 1.0 in
  let g = snd tmp and s = fst tmp in
  print_graph s;
  Graphics.set_color Graphics.red;
  print_res (greedy_approx g) s 0;
  Graphics.moveto  12 14;
  Graphics.draw_string "distance : ";
  Graphics.draw_string (string_of_float (fst (greedy_approx g)));
  
  Graphics.set_color Graphics.black;
  print_res (tsp_coupure g) s 2;
  Graphics.moveto 12 0;
  Graphics.draw_string "distance : ";
  Graphics.draw_string (string_of_float (fst (tsp_coupure g)));
  Graphics.moveto 248 0;
  Graphics.draw_string "tapez 'espace' pour quitter";
  while (Graphics.read_key ()) <> ' ' do
    ();
  done;;

main ();;
