let results = Array.make 50 0;;

let print_results () = 
  for i = 0 to 20 do
    let ii = float_of_int i in
      Printf.printf "entre %f et %f : %u\n" (ii *. 0.05 +. 11.8) (ii *. 0.05 +. 11.85) results.(i)
  done;;

let fusionne_en_boucle () =
  Random.self_init (); 
  let s = Resultats.defi_250 in
    let g = Graphe.complete s in
    Printf.printf "Generating initial heuristic ..."; flush stdout;
(*    let depart = ref (Twooptjulien.two_opt g (snd (GreedyApprox.greedy_approx g))) in *)
     let depart = ref (TwoOpt.two_opt g (snd (GreedyApprox.greedy_approx g))) in 
    let res = ref !depart in
      let lngres = ref (Trajet.longueur g !res) in 
      Printf.printf "Done (%f)\nLooping : \n" !lngres; flush stdout;
      at_exit print_results; 
      
      while true do
               if Random.int 5 = 1 then depart := !res;
               if Random.int 5 = 2 then depart := TwoOpt.two_opt g (Permutation.aleatoire g);
               let tmp = (TwoOpt.two_opt g (TwoOpt.recuit_simule g !depart 0.0 )) in
               
               if Trajet.longueur g tmp < !lngres then
                 res := Fusion.super_crossing g tmp !res
               else  
                 res := Fusion.super_crossing g !res tmp;
               
               let bidon = Trajet.longueur g !res in
                 if abs_float (bidon -. !lngres) > 0.00001 then
                   (
                     lngres := bidon;
                     print_newline (); 
                     Graphiques.print_res (!lngres, !res) s 0;
                     print_newline ();
                  
                   )
                  else 
                   print_char 'x';
              flush stdout;       
     done;;


let rech_recuit () =
let s = Resultats.defi_250 in
let g = Graphe.complete s in
   Graphips.open_graph ""; 
   Graphiques.sortie_ps false;
   
   Random.self_init ();

   let t = Acm.acm_prim g 0 in
   let b = Acm.construit_bon_arbre t in
(*   let p1 = Acm.parcours_prefixe [] (Acm.extrait_tournee b) in*)
   let p1 = snd (GreedyApprox.greedy_approx g) in 
   let min = ref 100.0 and best = ref p1 in

   while true do
     let p = TwoOpt.recuit_simule g !best 0.0 in
     if (Trajet.longueur g p < !min) then begin
         min := Trajet.longueur g p;  
         best := p;
         Graphiques.print_res ((Trajet.longueur g p), p) s 0;
     
     end
   else
     Printf.printf "*";
         flush(stdout);
   done;;
   
let rech_acm () =
let s = Resultats.defi_250 in
let g = Graphe.complete s in
   Graphips.open_graph ""; 
   Graphiques.sortie_ps false;
   
   Random.self_init ();

   let t = Acm.acm_prim g 0 in
   let b = Acm.construit_bon_arbre t in
   let p = Acm.parcours_prefixe [] (Acm.extrait_tournee b) in

   Graphiques.print_res ((Trajet.longueur g p), p) s 0;;



let rech_exhaustive () =
  Graphiques.sortie_ps false;
  Graphips.open_graph "";
  
  let s, g = Graphe.aleatoire 20 1.0 1.0 in
    
    let parcours = Exhaustif.tsp_coupure g in
      Graphiques.print_graph s;
      Graphiques.print_res parcours s 0;;


let rech_greedy () =
let s = Resultats.defi_250 in
let g = Graphe.complete s in
   Graphips.open_graph "";
   Graphiques.sortie_ps false;
   
   let  p1 = snd (GreedyApprox.greedy_approx g) in
   let p = TwoOpt.two_opt g p1 in 

   Graphips.set_color 0xff;
   Graphiques.print_res ((Trajet.longueur g p), p) s 0;
   
   Graphips.set_color 0xff0000;
   Graphiques.print_graph s;
   read_line ();;

let affiche_meilleurs () =
let s = Resultats.defi_250 in
let g = Graphe.complete s in
   Graphips.open_graph "";
   Graphiques.sortie_ps true;
   
   let p = Resultats.meilleurs.(4) in
   Graphips.set_color 0xff;
   Graphiques.print_res ((Trajet.longueur g p), p) s 0;
   
   Graphips.set_color 0xff0000;
   Graphiques.print_graph s;
   Graphips.close_graph ();;


 ();

fusionne_en_boucle ();
