(***** Creation des graphes de tests pour le voyageur de commerce *****)

let create n = Array.make_matrix n n 0.0;;

let dist_eucl a b = sqrt ((fst a -. fst b)**2.0 +. (snd a -. snd
  b)**2.0);;

let complete arretes =
  let tab = create (Array.length arretes) in
  for i = 0 to (Array.length arretes)-1 do
    for j=0 to (Array.length arretes)-1 do
      tab.(i).(j) <- dist_eucl arretes.(i) arretes.(j);
    done;
  done;
  tab;;

let aleatoire n x_lim y_lim =
  let arretes = Array.make n (0.0,0.0) in
  Random.self_init ();
  for i=0 to n-1 do
    arretes.(i) <- (Random.float x_lim,Random.float y_lim);
  done;
  arretes, complete arretes;;