let random_cell n g = 
  Printf.printf "Generating random cell : %.2f %%" 0.0;
  flush stdout;
  let cell = Array.make n (0.0, []) in
    for i = 0 to n-1 do
   (*   let res = ref [] and lng = ref 10000.0 in
      for i = 0 to 10 do
        let tmp = TwoOpt.recuit_simule g (Permutation.aleatoire g) 0.0 in
          let l = Trajet.longueur g tmp in
            if l < !lng then 
              (
                lng := l;
                res := tmp
              )  
      done;
      cell.(i) <- !lng, !res ;*)
     
      let tmp = TwoOpt.recuit_simule g (Permutation.aleatoire g) 0.0 in
      cell.(i) <- Trajet.longueur g tmp, tmp;
      Printf.printf "\rGenerating random cell : %.2f %% " ((float_of_int i) /. (float_of_int (n-1))*.100.); 
      flush stdout;  
    done;
    Printf.printf "\n"; flush stdout;  
    Array.fast_sort (fun (c1,_) (c2,_) -> Pervasives.compare c1 c2) cell;    
    cell;;
    
let reduce_cell g cell level cote = 
  Printf.printf "Reducing cell (lvl %u, %s): %.2f %%" level cote 0.0;
  let taille = Array.length cell in
  let pivot = taille/2 in
    
  for i = 0 to pivot do
    for j = pivot + 1 to taille - 1 do
      let t = Fusion.super_crossing g (snd cell.(i)) (snd cell.(j)) in
      cell.(i) <- (Trajet.longueur g t), t;
      Printf.printf "\rReducing cell (lvl %u, %s) : %.2f %%" level cote ((float_of_int i) /. (float_of_int pivot)*.100.);
      flush stdout;
    done; 
  done;
  
  
  let res = Array.sub cell 0 (pivot + 1) in
    Array.fast_sort (fun (c1,_) (c2,_) -> Pervasives.compare c1 c2) res;
    Printf.printf " Complete. Best : %f \n" (fst res.(0));  
    res;;
    
let merge_cells c1 c2 = 
  let cell = Array.append c1 c2 in
    Array.fast_sort (fun (c1,_) (c2,_) -> Pervasives.compare c1 c2) cell;
    cell;;

let rec amaigrissement g c = 
  let res = ref (snd c.(0)) in
    for i = (Array.length c) - 1 downto 1 do
      res := Fusion.super_crossing g !res (snd c.(i));
      Printf.printf "\rEffonfrement de cellule : %.2f" ((float_of_int i) /. (float_of_int ((Array.length c) - 1) *. 100.));
      flush stdout;
    done;
    print_newline ();
    Trajet.longueur g !res, !res;;
    
    
let rec cell_tree g taille_cell = function
  0 -> random_cell taille_cell g
| n -> let c1 = cell_tree g taille_cell (n-1) and c2 = cell_tree g taille_cell (n-1) in
        let c1 = reduce_cell g c1 n "gauche" and c2 = reduce_cell g c2 n "droite" in
          merge_cells c1 c2;;

