(* Arbre couvrant minimal avec l'algorithme de Prim *)

type t_clef = Infini | Val of float;;
type t_min  = Empty | Min of t_clef * int;;
type t_arbre_nul  = Nil | Pere of int;;
type t_arbre = Vide | Noeud of int * t_arbre list;;

(************************ gestion des tas binaires **********************************)

let compare i j = 
  match i, j with
  Infini, _ -> false  
| _, Infini -> true
| Val x, Val y -> x<y;;

class tas_binaire clefs_init  = 
  object (self)

(* la clef initialement  la position i est actuellement  la position a.(i) *)
    val a = Array.make (Array.length clefs_init) 0

(*  la clef  la position i est la clef initialement  la position b.(i) *)
		val b = Array.make (Array.length clefs_init) 0
    val clefs = clefs_init

    val mutable taille = Array.length clefs_init - 1
    method private decr_taille = taille <- taille - 1
    
(* taille = n du dernier element ! *)

    method pere i = (i-1)/2
    method gauche i = 2 * i+1
    method droit i = 2 * i + 2

(* true pour a<b *)
    method private compare i j = 
      match clefs.(i), clefs.(j) with
        Infini, _ -> false  
      | _, Infini -> true;
      |	Val x, Val y -> x<y	

    method private swap i j =
        let tmp = clefs.(i) and tmp2 = b.(i) in
           
           clefs.(i) <- clefs.(j);
	   clefs.(j) <- tmp;
           a.( b.(i) ) <- j;
	   a.( b.(j) ) <- i; 
     
(* swaper les b *)
           b.(i) <- b.(j);
	   b.(j) <- tmp2


    method private entasser i = 
        let l = self#gauche i and r = self#droit i and min = ref 0 in
 
          if l <= taille &&  self#compare l i then    
            min := l
          else
            min := i;
 
         if r <= taille && self#compare r !min then min := r;
 
         if !min != i then 
          ( 
            self#swap !min i;
            self#entasser !min;
          )

	 initializer 
      for i = 0 to taille do
        a.(i) <- i;
        b.(i) <- i;
			done;

      for i = taille/2 + 1 downto 0 do
        self#entasser i
      done

    method extraire_min =
      if taille = -1 then Empty else ( 
      let min = clefs.(0) and min2 = b.(0) in
       
       (* a .(taille) <- 0;
       b.(0) <- b.(taille);
       clefs.(0) <- clefs.(taille); *)
        
       self#swap 0 taille; 
        
       self#decr_taille;
       self#entasser 0;
       Min (min, min2)
			)
    
    method diminuer_clef i nouv =
      clefs.(a.(i)) <- nouv;
     let actuel = ref a.(i) in
     try
       while !actuel > 0 do
        let papa = self#pere !actuel in
          if self#compare !actuel papa then 
           ( 
             self#swap !actuel papa;
             actuel := papa;
           )
         else raise Exit    
     done;
    with Exit -> ()

    method dump = 
          clefs, a,b
          
    method appartient i = a.(i) <= taille
    
    method lire_clef i = clefs.(a.(i))

end;;    

(************************* arbres *****************************************)

let rec extrait_tournee = function
  Vide -> []
| Noeud (a, fils) -> a::(List.concat (List.map (function x -> x@[a]) (List.map extrait_tournee fils)));;

let rec parcours_prefixe vus = function
  [] -> vus@[List.hd vus]
| x::suite when List.mem x vus -> parcours_prefixe vus suite
| x::suite                     -> parcours_prefixe (vus@[x]) suite;;
 

let rec est_dans element = function
| Vide -> false
| Noeud (a, fils) -> a=element || List.exists (est_dans element) fils;;

(*  priori, ajoute_arbre fonctionne bien *)

let rec ajoute_foret elmt papa = function
  [] -> []
| x::suite -> (ajoute_arbre elmt papa x)::(ajoute_foret elmt papa suite)
and 
ajoute_arbre elmt papa = function
| Vide -> failwith "anormal bis"
| Noeud (a, fils) when a=papa -> Noeud (a, (Noeud (elmt, []))::fils)
| Noeud (a, fils) -> Noeud (a, ajoute_foret elmt papa fils);;


let rec greffe arbre waiting = function
    [] -> ( match waiting with
            [] -> arbre
          | _  -> greffe arbre [] waiting
          )
  | (n, Nil)::suite -> greffe (Noeud (n, [])) waiting suite
  | (n, Pere p)::suite -> if est_dans p arbre then 
                            greffe (ajoute_arbre n p arbre) waiting suite
                          else
                            greffe arbre ((n, Pere p)::waiting) suite;;


let construit_bon_arbre mauvais = 
  let bad = ref [] in
    for i = 0 to (Array.length mauvais) -1 do
      bad := !bad@[(i, mauvais.(i))]
    done;  
  greffe Vide [] !bad;;  
  
let rec to_aretes_ i = function
  [] -> []
| Nil::suite -> to_aretes_ (i+1) suite 
| (Pere j)::suite -> (i,j) :: (to_aretes_ (i+1) suite);; 

let to_aretes t = to_aretes_ 0 (Array.to_list t);;

let acm_prim g depart = 
  let n = (Array.length g) in
    let clefs = Array.make n Infini and sous_arbre = Array.make n Nil in 
      clefs.(depart) <- Val 0.0;
      
      let b_heap = new tas_binaire clefs in 
      try  
        while true do 
          match b_heap#extraire_min with
          | Empty -> raise Exit
	  | Min (key,u) -> 
	        for v = 0 to n - 1 do
	          if v != u then 
	          (
	            
	            if b_heap#appartient v then (
	              
	              if compare (Val g.(u).(v)) (b_heap#lire_clef v) then 
	            (
	              
	              sous_arbre.(v) <- Pere u;
	              b_heap#diminuer_clef v (Val g.(u).(v))
	            ) 
	          ))
	        done;
	done;
	sous_arbre;
      with
        Exit -> sous_arbre;;
        
let print arbre s = 
  for i = 0 to (Array.length arbre) - 1 do
    let x = int_of_float ( float_of_int ( Graphips.size_x () - 20) *. (fst s.(i)) ) + 10
    and y = int_of_float ( float_of_int ( Graphips.size_y () - 20) *. (snd s.(i)) ) + 10 in
      match arbre.(i) with
         Nil ->  ()
       | Pere u -> 
       	           let x2 = int_of_float ( float_of_int ( Graphips.size_x () - 20) *. (fst s.(u)) ) + 10
                   and y2 = int_of_float ( float_of_int ( Graphips.size_y () - 20) *. (snd s.(u)) ) + 10 in		
                     Graphips.draw_segments [|(x,y,x2,y2)|];
  done;;  

let super_acm_prim g s = 
  let meil_cout = ref 100000.0 and meil_parcours = ref [] and meil_arbre = ref [||]  in  
    
      
      for i = 0 to (Array.length g) - 1 do
        let t = acm_prim g i in
        let b = construit_bon_arbre t in 
          let p = parcours_prefixe [] (extrait_tournee b) in
            if Trajet.longueur g p < !meil_cout then
              (
                meil_cout := (Trajet.longueur g p);
                meil_parcours := p;
                meil_arbre := t;
              )  
    done;
    (!meil_cout, !meil_parcours);;
  

 
