(* continuation passing style *)

open Mltype;;


(************************* gestion des environnements ***********************)

module OrderedString = 
  struct
    type t = String.t
    let compare = String.compare
  end

(* Ensemble de variables de types *)
module Env = Map.Make(OrderedString)


(* renvoie v[x := u] (la substitution, pas la Beta-rÃ©duction) *)
let rec subs x u = function
    | Variable y when y = x -> u
    | Variable y -> Variable y
    | Lambda (y, _) when y=x -> failwith ("Capture de variable : " ^ y);
    | Lambda (y, s) -> Lambda (y, subs x u s)
    | App (a,b) -> App (subs x u a, subs x u b)
    | Concat (a,b) -> Concat (subs x u a, subs x u b)
    | Plus (a,b) -> Plus (subs x u a, subs x u b)
    | Moins (a,b) -> Moins (subs x u a, subs x u b)
    | Fois (a,b) -> Fois (subs x u a, subs x u b)
    | Divise (a,b) -> Divise (subs x u a, subs x u b)
    | Reste (a,b) -> Reste (subs x u a, subs x u b)
    | Egal (a,b) -> Egal (subs x u a, subs x u b)
    | Inferieur (a,b) -> Inferieur (subs x u a, subs x u b)
    | Empty -> Empty 
    | Cons (a,b) -> Cons (subs x u a, subs x u b)
    | Const c -> Const c
    | Oppose a -> Oppose (subs x u a)
    | Si (a,b,c) -> Si (subs x u a, subs x u b, subs x u c)

(* hmmmm... il pourrait y avoir des pb ici (Ã  cause du "a") *)
    | Let (a,b,c) -> Let (a, subs x u b, subs x u c)
    | LetRec (a,b,c) -> LetRec (a, subs x u b, subs x u c)
    | Callcc(k,a) -> Callcc(k, subs x u a)
    | Throw(a,b) -> Throw (subs x u a, subs x u b)
    | Call_cc -> Call_cc

(******************* main evaluation loop ***********************)

let rec take_2_ints cont env d u v = 
  let k = (function 
	     | Entier a -> eval (function 
					     | Entier b -> cont (d a b)
					     | _ -> raise Bottom (* entier attendu *)
					  ) env v
	     | _ -> raise Bottom (* entier attendu *)
	  )
  in
    eval k env u	  
and
eval (cont : t_cont) env = function (* expr -> t_domaine *)
  | Const c -> cont c

  | Variable x -> 
(*      Printf.printf "looking for %s\n" x;*)
      cont (Env.find x env)

  | Lambda (x,t) -> cont (Fonction (fun (cont_, d) -> eval cont_ (Env.add x d env) t))

  | App (u, v) -> 
      let k = (function 
		 | Fonction f -> eval (function d -> f (cont, d) ) env v
		 | _ -> raise Bottom (* fonction binaire attendue *)
	      )
      in
	eval k env u

(* opÃ©rations arithmÃ©tiques sur les entiers *)
  | Oppose u -> eval (function 
			| (Entier n) -> Entier (-n)
			| _ -> raise Bottom (* entier attendu *)
		     ) env u
  | Plus (u, v) -> take_2_ints cont env (fun a b -> Entier (a+b)) u v 
  | Moins (u,v) -> take_2_ints cont env (fun a b -> Entier (a-b)) u v 
  | Fois (u,v) -> take_2_ints cont env (fun a b -> Entier (a*b)) u v 
  | Divise (u,v) -> take_2_ints cont env (fun a b -> Entier (a/b)) u v 
  | Reste (u,v) -> take_2_ints cont env (fun a b -> Entier (a mod b)) u v 

(* pour l'instant, on ne teste que l'Ã©galitÃ© sur les entiers *)
  | Egal (u,v) -> take_2_ints cont env (fun a b -> Booleen (a=b)) u v 
  | Inferieur (u,v) -> take_2_ints cont env (fun a b -> Booleen (a<b)) u v 

(* Instruction conditionnelle *)
  | Si (u,v,w) ->
      let k = (function 
	     | Booleen true -> eval cont env v
	     | Booleen false -> eval cont env w
	     | _ -> raise Bottom (* boolÃ©en attendu *)
	  )
  in
    eval k env u	  

(* let -- l'indispensable *)

  | Concat(u,v) ->
      let k = function 
      | String d -> eval (function 
			    | String e -> cont (String (d^e))
			    | _ -> raise Bottom
			 ) env v
      | _ -> raise Bottom 
      in
	eval k env u 

  | Let (u,v,w) -> 
      let k = function d -> eval cont (Env.add u d env) w in
	eval k env v

(* vieux hack pourri *)
  | LetRec (u,v,w) -> 
      let delta = Lambda ("x", App(Variable "x", Variable "x")) in
      let fresh_u = u ^ "__" in
      let rewrited_function = Lambda (fresh_u, subs u (App (Variable fresh_u, Variable fresh_u)) v) in
      let equivalent_term = App (delta, rewrited_function) in
	
      eval cont env (Let (u, equivalent_term, w))

(* gestion des listes *)
  | Empty -> cont (Liste [])
  | Cons (x, suite) ->       
      let k = (function u -> eval (function 
				     | Liste l -> cont (Liste (u::l))
				     | _ -> raise Bottom (*liste attendue *)
					 
				  ) env suite
	      )
  in
    eval k env x	  

(* gestion des continuations *)

(* le callcc k in u [deprecated] *)
  | Callcc (k, u) -> eval cont (Env.add k (Continuation cont) env) u
  | Throw (k, v) ->  eval (function 
			     | Continuation k_ -> eval k_ env v  
			     | _ -> raise Bottom (* continuation attendue *)
			  ) env k

(* le call/cc *)
  | Call_cc -> cont (Fonction (function 
				 | (k, Fonction f) -> f 
				     (k, (Fonction (function (_, d) -> k d)))
				 | _ -> raise Bottom
			      )
		    )

(***************************************************************************)

(* pour pouvoir overloader = (par exemple, pour l'avoir sur les chaines, les entiers, les listes, les tuples....), il faudra un typeur statique[ou run-time, mais c'est pourri]. NOTE : c'est quoi le type de call/cc ? *)

let env_vide = Env.empty

let rec string_of_domaine = function
  | Entier x -> string_of_int x;
  | Liste l -> Printf.sprintf "[%s]" (String.concat ";" (List.map string_of_domaine l))
  | Booleen true -> "true"
  | Booleen false -> "false"
  | Float f -> string_of_float f
  | String s -> "\"" ^ s ^ "\""
  | Fonction f -> "<fun>"
  | Continuation c -> "<cont>"

let rec k_start e = 
  Printf.printf "%s\n" (string_of_domaine e); 
  e


let main =
  let fact = "let rec fact = fun n -> if n=0 then 1 else n * fact (n-1) in fact 10;;" in

  let brainstorm = "
call/cc (fun z -> 
let u = call/cc (fun f -> 
let v = call/cc (fun g -> f g) in z (\"j'aime le \" ^ v))
in 
  u \"café\"
)" in 



  let fib = "let rec fib = fun n -> if n < 3 then 1 else fib(n-1) + fib(n-2) in fib(10);;" in

  let s = "\"coucou\" ^\" charles\"" in

    let lexbuf = Lexing.from_string brainstorm in
    let result = Parser.program Lexer.token lexbuf in

      print_string "parsing finished. Running program: ";
      try 
	eval k_start env_vide result
      with
	  Bottom -> failwith "crash !\n"


